import os
import sys

# update thalassa from version 2025-09-01_1352 to version 2025-10-14_1839
# a batch script to:
#  add new columns to the database
#  check all files in a thalassa archive for existing thumbnails, thumbnail video clips, summaries, and summary video clips 
#  and to set their database fields accordingly


# enter the absolute path to your thalassa config file here
config_file_path = 'YOUR_THALASSA_CONFIG_FILE_PATH'
# then put this file in the same directory as your thalassa.py and run it from the command line
# e.g. `python3 ./thalassa_update.version_2025-09-01_1352_to_version_2025-10-14_1839.py`

current_dir_path = os.path.dirname(os.path.realpath(__file__))
sys.path.append(current_dir_path)

try:
	from thalassa import Thalassa
except Exception as e:
	# dependency failure or other init problems
	try:
		with open(current_dir_path + '/thalassa.log', 'a') as fh:
			fh.write(str(e))
	except:
		raise ValueError('Problem writing to log')
	print(e)
	sys.exit(-1)

try:
	thalassa = Thalassa(config_file_path)
except Exception as e:
	#Missing configuration
	#Problem getting configuration
	#Problem initializing tokens file
	#Problem getting active tokens
	print(e)
	sys.exit(-1)


# alter table
import sqlite3
try:
	with sqlite3.connect(thalassa.config['database_file_path']) as connection:
		cursor = connection.cursor()
		cursor.execute('ALTER TABLE files ADD COLUMN thumbnail TEXT NOT NULL DEFAULT \'\';', [])
		cursor.execute('ALTER TABLE files ADD COLUMN thumbnail_video_clip TEXT NOT NULL DEFAULT \'\';', [])
		cursor.execute('ALTER TABLE files ADD COLUMN summary TEXT NOT NULL DEFAULT \'\';', [])
		cursor.execute('ALTER TABLE files ADD COLUMN summary_video_clip TEXT NOT NULL DEFAULT \'\';', [])
except Exception as e:
	thalassa.log(str(e))
	print(e)
	sys.exit(-1)


### get file thumbnail and summary states
files_with_thumbnails = []
files_with_thumbnail_video_clips = []
files_with_summaries = []
files_with_summary_video_clips = []
try:
	# loop through pages of default thalassa page size until no results are returned
	file_count = 0
	page = 0
	(total_results, total_pages, total_size, perpage, file_ids_order, file_records, results_this_page) = thalassa.search_file_records(page=-1)
	while 0 < results_this_page:
		(total_results, total_pages, total_size, perpage, file_ids_order, file_records, results_this_page) = thalassa.search_file_records(page=page)
		if 0 == results_this_page:
			break
		file_ids_to_check = file_ids_order[:results_this_page]
		page += 1
		file_count += results_this_page
		for file_id in file_ids_to_check:
			file_record = file_records[file_id]

			# thumbnail
			if os.path.exists(
				os.path.join(
					thalassa.config['files_directory_path'],
					'thumbnail',
					file_record['file_id'] + '.' + thalassa.config['thumbnail_format']
				)
			):
				files_with_thumbnails.append(file_record['file_id'])

			#thumbnail video clip
			if file_record['mimetype'] in thalassa.category_mimes['video']:
				if os.path.exists(
					os.path.join(
						thalassa.config['files_directory_path'],
						'thumbnail',
						file_record['file_id'] + '.webm'
					)
				):
					files_with_thumbnail_video_clips.append(file_record['file_id'])

			# summary
			if os.path.exists(
				os.path.join(
					thalassa.config['files_directory_path'],
					'summary',
					file_record['file_id'] + '.' + thalassa.config['summary_format']
				)
			):
				files_with_summaries.append(file_record['file_id'])

			# summary video clip
			if os.path.exists(
				os.path.join(
					thalassa.config['files_directory_path'],
					'summary',
					file_record['file_id'] + '.webm'
				)
			):
				files_with_summary_video_clips.append(file_record['file_id'])
except Exception as e:
	thalassa.log(str(e))
	#Problem getting file records
	print(e)
	sys.exit(-1)

try:
	with sqlite3.connect(thalassa.config['database_file_path']) as connection:
		cursor = connection.cursor()

		# clear all db thumbnails, thumbnail video clips, summaries, summary video clips
		cursor.execute('UPDATE files SET thumbnail=?,thumbnail_video_clip=?,summary=?,summary_video_clip=? WHERE 1;', ['','','',''])
		# thumbnails
		if 0 < len(files_with_thumbnails):
			sql = 'UPDATE files SET thumbnail=? WHERE file_id IN ('
			values = [thalassa.config['thumbnail_format']]
			for file_id in files_with_thumbnails:
				sql += '?,'
				values.append(file_id)
			cursor.execute(sql[:-1] + ');', values)
		# thumbnail video clips
		if 0 < len(files_with_thumbnail_video_clips):
			sql = 'UPDATE files SET thumbnail_video_clip=? WHERE file_id IN ('
			values = ['webm']
			for file_id in files_with_thumbnail_video_clips:
				sql += '?,'
				values.append(file_id)
			cursor.execute(sql[:-1] + ');', values)
		# summaries
		if 0 < len(files_with_summaries):
			sql = 'UPDATE files SET summary=? WHERE file_id IN ('
			values = [thalassa.config['summary_format']]
			for file_id in files_with_summaries:
				sql += '?,'
				values.append(file_id)
			cursor.execute(sql[:-1] + ');', values)
		# summary video clips
		if 0 < len(files_with_summary_video_clips):
			sql = 'UPDATE files SET summary_video_clip=? WHERE file_id IN ('
			values = ['webm']
			for file_id in files_with_summary_video_clips:
				sql += '?,'
				values.append(file_id)
			cursor.execute(sql[:-1] + ');', values)
except Exception as e:
	thalassa.log(str(e))
	print(e)
	sys.exit(-1)

print('files:' + str(file_count))
print('pages:' + str(page))
print('files with thumbnails:' + str(len(files_with_thumbnails)))
print('files with thumbnail video clips:' + str(len(files_with_thumbnail_video_clips)))
print('files with summaries:' + str(len(files_with_summaries)))
print('files with summary_video_clips:' + str(len(files_with_summary_video_clips)))
sys.exit(0)
