import os
import sys

current_dir_path = os.path.dirname(os.path.realpath(__file__))
sys.path.append(current_dir_path)

try:
	from thalassa import Thalassa
except Exception as e:
	# dependency failure or other init problems
	try:
		with open(current_dir_path + '/thalassa.log', 'a') as fh:
			fh.write(str(e))
	except:
		raise ValueError('Problem writing to log')
	print(e)
	sys.exit(-1)

FILE_PATHS_SEPARATOR = '///'

# arguments
bool_arguments = [
	# modes
	'version',
	'info',
	# pass
	'set-first-pass',
	'set-pass',
	'check-pass',
	'change-pass',
	# token
	'check-token',
	'list-tokens',
	'generate-token',
	'write-new-token',
	'set-tokens-mode',
	'set-token-name',
	'remove-tokens',
	# db
	'initialize-database',
	# files
	'store-files',
	'remove-files',
	'set-publish-time',
	'rebuild',
	'search-files',
	'edit-files-tags',
	'list-tags',
	'remove-tags',
	'replace-tag',
	'accompany-tag',
	'generate-set',
	'rebuild-all',
	'cleanup',
	# bools
	'comma-separated-tags',
	'exclude-future',
	'include-meta',
	'remove',
	'replace',
	'thumbnails',
	'sync',
	'orphan-tags',
	'orphan-files',
	'orphan-thumbnails',
]

value_arguments = [
	# init
	'config',
	'use-token',
	# pass
	'current-pass',
	'new-pass',
	'new-pass-confirmation',
	# tokens
	'token',
	'tokens',
	'name',
	'token-mode',
	# files
	'file-paths',
	'filenames',
	'file-ids',
	'tags',
	'exclude-tags',
	'tag',
	'old-tag',
	'new-tag',
	'datetime',
	'page',
]
args = {}
for arg in bool_arguments:
	args[arg] = False
for arg in value_arguments:
	args[arg] = None

for arg in sys.argv:
	arg = arg[2:]
	eq_index = arg.find('=')

	if -1 != eq_index:
		(arg,value) = arg.split('=')
		if arg in value_arguments:
			args[arg] = value
	elif arg in bool_arguments:
		args[arg] = True

config_file_path = os.path.join(current_dir_path, '.thalassa_config_example.txt')
provided_token = None
if 'config' in args:
	config_file_path = args['config']
if 'use-token' in args:
	provided_token = args['use-token']

try:
	thalassa = Thalassa(config_file_path, provided_token)
except Exception as e:
	#Missing configuration
	#Problem getting configuration
	#Problem initializing tokens file
	#Problem getting active tokens
	print(e)
	sys.exit(-1)

def require_args(required_args, args):
	for arg in required_args:
		if arg not in args or '' == args[arg]:
			print('Missing args')
			sys.exit(-1)

# init
if args['version']:
	print('thalassa ' + thalassa.version)
	sys.exit(0)
elif args['info']:
	#TODO synchronize actual config values with this output later
	res = 'thalassa_version' + "\t" + thalassa.version + "\n"
	res += 'thalassa_dir_path' + "\t" + thalassa.dir_path + "\n"
	res += 'thalassa_config_file_path' + "\t" + thalassa.config_file_path + "\n"
	res += 'provided_token' + "\t"
	if thalassa.provided_token:
		str(thalassa.provided_token)
	res += "\n"
	res += 'authorized' + "\t" + str(int(thalassa.authorized)) + "\n"
	res += 'token_mode' + "\t" + thalassa.token_mode + "\n"
	res += 'pass_set' + "\t" + str(int(thalassa.is_first_pass_set())) + "\n"

	for (key, value) in thalassa.config.items():
		res += 'config_' + key + "\t" + str(value) + "\n"

	print(res)
	sys.exit(0)

# pass
elif args['set-first-pass'] or args['set-pass']:
	require_args(['new-pass', 'new-pass-confirmation'], args)
	if args['set-first-pass'] and thalassa.is_first_pass_set():
		print('Pass already set')
		sys.exit(-1)
	try:
		thalassa.set_pass(args['new-pass'], args['new-pass-confirmation'])
	except Exception as e:
		thalassa.log(str(e))
		#New pass not entered
		#New pass confirmation mismatch
		#Problem writing pass hash
		print(e)
		sys.exit(-1)
	print('Pass set')
	new_token = thalassa.write_new_token('admin')
	print(new_token)
	if args['set-first-pass']:
		# always try to initialize database here
		# since it should happen when setting first pass
		# and doesn't hurt anything to try to do it infrequently if you ever have to set first pass again in the future
		try:
			thalassa.initialize_database()
		except Exception as e:
			thalassa.log(str(e))
			#Problem creating tables
			#Problem initializing database
			print(e)
			sys.exit(-1)
	sys.exit(0)
elif args['check-pass']:
	require_args(['current-pass'], args)
	if not thalassa.is_first_pass_set():
		print('Pass not set')
		sys.exit(-1)
	try:
		if thalassa.is_correct_pass(args['current-pass']):
			print('Correct pass')
			new_token = thalassa.write_new_token('admin')
			print(new_token)
			sys.exit(0)
	except Exception as e:
		thalassa.log(str(e))
		#Pass not set
		print('Incorrect pass')
		sys.exit(-1)
	print('Incorrect pass')
	sys.exit(-1)
elif args['change-pass']:
	require_args(['current-pass', 'new-pass', 'new-pass-confirmation'], args)
	try:
		thalassa.change_pass(args['current-pass'], args['new-pass'], args['new-pass-confirmation'])
	except Exception as e:
		thalassa.log(str(e))
		#Problem reading pass hash
		#Pass not set
		#Problem writing pass hash
		#Current pass not entered
		#Incorrect pass
		#New pass not entered
		#New pass confirmation mismatch
		#Current pass not entered, New pass not entered
		#Current pass not entered, New pass confirmation mismatch
		#Incorrect pass, New pass not entered
		#Incorrect pass, New pass confirmation mismatch
		print(e)
		sys.exit(-1)
	print('Pass changed')
	sys.exit(0)

# token
elif args['check-token']:
	require_args(['token'], args)
	token = args['token']
	if token not in thalassa.active_tokens:
		print('Invalid token')
		sys.exit(-1)
	print('Valid token')
	sys.exit(0)
elif args['list-tokens']:
	import json
	print(json.dumps(thalassa.active_tokens))
	sys.exit(0)
elif args['write-new-token']:
	try:
		new_token = thalassa.write_new_token()
		print('Wrote new token')
		print(new_token)
		sys.exit(0)
	except Exception as e:
		thalassa.log(str(e))
		#Problem writing tokens
		print(e)
elif args['set-tokens-mode']:
	require_args(['tokens', 'token-mode'], args)
	tokens = args['tokens'].split(',')
	try:
		thalassa.set_tokens_mode(tokens, args['token-mode'])
	except:
		thalassa.log(str(e))
		#Problem writing tokens
		#TODO unfound tokens
		sys.exit(0)
	sys.exit(0)
elif args['set-token-name']:
	require_args(['token'], args)
	name = ''
	if 'name' in args:
		name = args['name']
	try:
		thalassa.set_token_name(args['token'], name)
	except Exception as e:
		thalassa.log(str(e))
		print(e)
		#Problem writing tokens
		#TODO unfound tokens
		sys.exit(0)
	sys.exit(0)
elif args['remove-tokens']:
	require_args(['tokens'], args)
	tokens = args['tokens'].split(',')
	try:
		thalassa.remove_tokens(tokens)
	except Exception as e:
		thalassa.log(str(e))
		#Problem writing tokens
		#TODO unfound tokens
		sys.exit(0)
	sys.exit(0)

# database
elif args['initialize-database']:
	try:
		thalassa.initialize_database()
	except Exception as e:
		thalassa.log(str(e))
		#Problem creating tables
		#Problem initializing database
		print(e)
		sys.exit(-1)
	sys.exit(0)

# files
elif args['store-files']:
	require_args(['file-paths'], args)
	source_file_paths_string = args['file-paths']
	source_file_paths = source_file_paths_string.split(FILE_PATHS_SEPARATOR)
	tags_string = args['tags']
	tags_separator = '#'
	if args['comma-separated-tags']:
		tags_separator = ','
	tags = thalassa.string_to_tags(tags_string, tags_separator)
	datetime_string = args['datetime']
	try:
		filenames = []
		if args['filenames']:
			filenames = args['filenames'].split(FILE_PATHS_SEPARATOR)
		file_ids_order = []
		file_records = thalassa.store_files(source_file_paths, tags, datetime_string, filenames)
		for file_id in file_records.keys():
			file_record = file_records[file_id]
			file_ids_order.append(file_id)
			file_record['tags'] = []
		thalassa.print_file_records(file_ids_order, file_records)
	except Exception as e:
		thalassa.log(str(e))
		#No file records provided
		#Problem creating file records
		print(e)
		sys.exit(-1)
	sys.exit(0)
elif args['remove-files']:
	require_args(['file-ids'], args)
	file_ids_string = args['file-ids']
	file_ids = file_ids_string.split(',')
	try:
		thalassa.remove_files(file_ids)
	except Exception as e:
		thalassa.log(str(e))
		#Problem removing file records
		print(e)
		sys.exit(-1)
	sys.exit(0)
elif args['set-publish-time']:
	require_args(['file-ids'], args)
	file_ids_string = args['file-ids']
	file_ids = []
	file_ids = file_ids_string.split(',')
	datetime_string = args['datetime']
	try:
		thalassa.set_publish_time(file_ids, datetime_string)
	except Exception as e:
		thalassa.log(str(e))
		#Problem setting file times
		print(e)
		sys.exit(-1)
	sys.exit(0)
elif args['rebuild']:
	require_args(['file-ids'], args)
	file_ids_string = args['file-ids']
	file_ids = file_ids_string.split(',')
	try:
		thalassa.rebuild_files(file_ids)
	except Exception as e:
		thalassa.log(str(e))
		print(e)
		#TODO
		sys.exit(-1)
	sys.exit(0)
elif args['search-files']:
	search_string = args['tags']
	tags_separator = '#'
	if args['comma-separated-tags']:
		tags_separator = ','
	search_tags = thalassa.string_to_tags(search_string, tags_separator)

	if args['exclude-future']:
		import time
		search_tags.append('older than:' + str(int(time.time())))
	(file_ids, filters, plain_tags) = thalassa.parse_search_tags(search_tags)
	page = -1
	if None != args['page']:
		page = int(args['page'])
	try:
		(total_results, total_pages, total_size, perpage, file_ids_order, file_records, results_this_page) = thalassa.search_file_records(file_ids=file_ids, filters=filters, tags=plain_tags, page=page)
		print(total_results)
		print(total_pages)
		print(total_size)
		print(perpage)
		print(results_this_page)

		thalassa.print_file_records(file_ids_order, file_records)

	except Exception as e:
		thalassa.log(str(e))
		#Problem getting file records
		print(e)
		sys.exit(-1)
	sys.exit(0)
elif args['edit-files-tags']:
	require_args(['file-ids'], args)
	file_ids_string = args['file-ids']
	file_ids = file_ids_string.split(',')

	tags = None
	if 'tags' in args:
		tags_string = args['tags']
		tags_separator = '#'
		if args['comma-separated-tags']:
			tags_separator = ','
		tags = thalassa.string_to_tags(tags_string, tags_separator)

	try:
		if args['remove']:
			thalassa.remove_files_tags(file_ids, tags)
		elif args['replace']:
			thalassa.replace_files_tags(file_ids, tags)
		else:
			thalassa.add_files_tags(file_ids, tags)
	except Exception as e:
		thalassa.log(str(e))
		#No file IDs or tags provided
		#Problem removing files tags
		#Problem adding files tags
		print(e)
		sys.exit(-1)
	sys.exit(0)
elif args['list-tags']:
	exclude_tags = []
	if args['exclude-tags']:
		tags_separator = '#'
		if args['comma-separated-tags']:
			tags_separator = ','
		exclude_tags = thalassa.string_to_tags(args['exclude-tags'], tags_separator)

	exclude_future = False
	if args['exclude-future']:
		exclude_future = True

	include_meta = False
	if args['include-meta']:
		include_meta = True

	try:
		tags = thalassa.get_tags_list(exclude_tags, exclude_future, include_meta)
	except Exception as e:
		thalassa.log(str(e))
		print(e)
	for (tag, count) in tags:
		print(tag + "\t" + str(count))
	sys.exit(0)
elif args['remove-tags']:
	require_args(['tags'], args)
	tags_separator = '#'
	if args['comma-separated-tags']:
		tags_separator = ','
	tags = thalassa.string_to_tags(args['tags'], tags_separator)
	try:
		thalassa.remove_tags(tags)
	except Exception as e:
		thalassa.log(str(e))
		#No tags provided
		#Problem removing tags
		print(e)
		sys.exit(-1)
	sys.exit(0)
elif args['replace-tag']:
	require_args(['old-tag', 'new-tag'], args)
	try:
		thalassa.replace_tag(args['old-tag'], args['new-tag'])
	except Exception as e:
		thalassa.log(str(e))
		#No source tag provided
		#No replacement tag provided
		#Problem replacing tag
		print(e)
		sys.exit(-1)
	sys.exit(0)
elif args['accompany-tag']:
	require_args(['tag', 'new-tag'], args)
	try:
		thalassa.replace_tag(args['tag'], args['new-tag'])
	except Exception as e:
		thalassa.log(str(e))
		#No target tag provided
		#No accompanying tag provided
		#Problem accompanying tag
		print(e)
		sys.exit(-1)
	sys.exit(0)
elif args['generate-set']:
	require_args(['file-ids'], args);
	file_ids_string = args['file-ids']
	file_ids = file_ids_string.split(',')
	try:
		new_set_id = thalassa.generate_set(file_ids, args['sync'])
	except Exception as e:
		thalassa.log(str(e))
		#No file IDs provided
		print(e)
		sys.exit(-1)
	print(new_set_id)
	sys.exit(0)
# for rebuilding all files in the archive
# probably should not be exposed in the web interface
elif args['rebuild-all']:
	import time
	try:
		(total_results, total_pages, total_size, perpage, file_ids_order, file_records, results_this_page) = thalassa.search_file_records(page=-1)
		print('total files:' + str(total_results))
		print('total pages:' + str(total_pages))
		# loop through pages of default thalassa page size until no results are returned
		file_count = 0
		page = 0
		while 0 < results_this_page:
			(total_results, total_pages, total_size, perpage, file_ids_order, file_records, results_this_page) = thalassa.search_file_records(page=page)
			if 0 == results_this_page:
				break
			print('rebuilding page ' + str(page + 1))
			print(' ' + str(results_this_page) + ' files')
			file_ids_to_rebuild = file_ids_order[:results_this_page]
			start_time = time.time()
			thalassa.rebuild_files(file_ids_to_rebuild)
			print(' page finished in ' + str(time.time() - start_time) + ' seconds')
			page += 1
			file_count += results_this_page
	except Exception as e:
		thalassa.log(str(e))
		#Problem getting file records
		#Problem setting file thumbnail/clip in record
		#Problem setting file summary/clip in record
		print(e)
		sys.exit(-1)
	sys.exit(0)
#TODO
elif args['cleanup']:
	#'orphan-tags',
	#'orphan-files',
	#'orphan-thumbnails',
	#Problem cleaning up orphan tags
	pass
# other
else:
	print('thalassa')
	sys.exit(-1)

sys.exit(0)
