<?php 
# a reference implementation of a thalassa web-based frontend written in php

include('thalassa_cli_interface.php');
include('thalassa_web_render.php');

# autogenerate tag suggestion lists automatically in intervals of CONFIG['tag_suggestions_autogeneration_age_seconds']
$last_generated_timestamp = file_get_contents(THALASSA_INFO['config_files_directory_path'] . 'last_tag_suggestions_generation.txt');
if (time() > intval($last_generated_timestamp) + CONFIG['tag_suggestions_autogeneration_age_seconds']) {
	generate_tag_suggestions();
}

# endpoints
$possible_endpoints = [
	'thalassa',
	'home',
	'help',
	'sign_in',
	'sign_out',
	'use_token',
	'page',
	'search',
	'feed',
	'view',
	'store',
	'admin',
	'tags',
	'change_pass',
	'tokens',
	'config',
	'storage',
	'initialize_database',
];
# usually default to thalassa's built-in home page if no endpoint is specified
$endpoint = 'home';
# but if the topmenu home uri is being used to link somewhere else then default to thalassa's search page if no endpoint is specified
if ('' != CONFIG['site_topmenu_home_uri']) {
	$endpoint = 'search';
}
if (array_key_exists('endpoint', QUERY_ARRAY) && in_array(QUERY_ARRAY['endpoint'], $possible_endpoints)) {
	$endpoint = QUERY_ARRAY['endpoint'];
} 

# limit what modes can be accessed
if (AUTHORIZED) {
	# trying to sign in while already authorized
	if ('sign_in' == $endpoint) {
		header('Location: search');
		exit();
	}
	# trying to access admin functions while not admin
	if ('admin' != TOKEN_MODE && in_array($endpoint, ['store', 'admin', 'tags', 'change_pass', 'tokens', 'config', 'storage', 'initialize_database'])) {
		header('Location: sign_in');
		exit();
	}
}
# not authorized
elseif (
		# auth required and trying to access anything other than sign in or use token
		(CONFIG['require_auth'] && !in_array($endpoint, ['sign_in', 'use_token'])) 
		# OR trying to access anything except home, sign in, use token, search, view, help, page, thalassa, or feed
		|| !in_array($endpoint, ['home', 'sign_in', 'use_token', 'search', 'view', 'help', 'page', 'thalassa', 'feed'])
	) {
	header('Location: sign_in');
	exit();
}

# minified response (preserving preformatted)
function send_min_response($res) {
	$pre_r = [];
	preg_match("/(<pre[^>]*>.*<\/pre>)/si", $res, $pre_r);
	$res = minify($res);
	foreach ($pre_r as $pre) {
		$res = str_replace(minify($pre), $pre, $res);
	}
	send_response($res);
}

function redirect($destination) {
	if (false === strpos($destination, 'http')) {
		$destination = THALASSA_URI . $destination;
	}
	header('Location: ' . $destination);
	exit();
}

if ('thalassa' == $endpoint) {
	send_min_response(render_endpoint_thalassa());
}
elseif ('home' == $endpoint) {
	send_min_response(render_endpoint_home());
}
elseif ('help' == $endpoint) {
	send_min_response(render_endpoint_help());
}
elseif ('sign_in' == $endpoint) {
	if (!PASS_SET) {
		send_min_response(render_endpoint_set_first_pass());
	}
	else {
		send_min_response(render_endpoint_sign_in());
	}
}
elseif ('sign_out' == $endpoint) {
	setcookie(
		CONFIG['cookie_name'],
		'',
		time() - 3600,
		'/',
		CONFIG['cookie_domain'],
		CONFIG['cookie_secure'],
		true
	);
	header('Location: ?');
	exit();
}
elseif ('use_token' == $endpoint) {
	send_min_response(render_endpoint_use_token());
}
elseif ('page' == $endpoint) {
	send_min_response(render_endpoint_page());
}
elseif ('search' == $endpoint) {
	send_min_response(render_endpoint_search());
}
elseif ('feed' == $endpoint) {
	send_response(render_endpoint_feed());
}
elseif ('view' == $endpoint) {
	send_min_response(render_endpoint_view());
}
elseif ('store' == $endpoint) {
	send_min_response(render_endpoint_store());
}
elseif ('admin' == $endpoint) {
	send_min_response(render_endpoint_admin());
}
elseif ('tags' == $endpoint) {
	send_min_response(render_endpoint_tags());
}
elseif ('change_pass' == $endpoint) {
	send_min_response(render_endpoint_change_pass());
}
elseif ('tokens' == $endpoint) {
	send_min_response(render_endpoint_tokens());
}
elseif ('config' == $endpoint) {
	send_min_response(render_endpoint_config());
}
elseif ('storage' == $endpoint) {
	send_min_response(render_endpoint_storage());
}
elseif ('initialize_database' == $endpoint) {
	send_min_response(render_endpoint_initialize_database());
}
 ?>